@extends(decide_template())

@section('title', $pageTitle)

@section('page_styles')
<link href="/resources/assets/css/spintags-create.css?v={{$local_version}}" rel="stylesheet" type="text/css">
@endsection

@section('page_scripts')
<script src="/themes/default/js/jquery.form.min.js" type="text/javascript"></script>
<script src="/themes/default/js/jquery.validate.js" type="text/javascript"></script>
<script src="/themes/default/js/additional-methods.js" type="text/javascript"></script>
<script src="/themes/default/js/init.js" type="text/javascript"></script>
<script src="/themes/default/js/select2.full.min.js" type="text/javascript"></script>
<script src="/themes/default/js/select2.js" type="text/javascript"></script>
<script src="/themes/default/js/form-controls.js" type="text/javascript"></script>
<script>
    var form_error="{{trans('common.message.form_error')}}";
</script>
<script src="/themes/default/js/includes/spin_tags.js?v={{time()}}" type="text/javascript"></script>
@endsection

@section(decide_content())

@if($errors->any())
    <!-- For PHP validations errors-->
    <div class="alert alert-danger" data-name="WKugIwZU">
        @foreach($errors->all() as $error)
            <p>{{ $error }}</p>
        @endforeach
    </div>
@endif
<!-- will be used to show any messages -->
@if (Session::has('msg'))
<div class="alert alert-success" data-name="rzRBrJQl">
    {{ Session::get('msg') }}
</div>
@endif
<!-- will be used to show any messages -->
<div id="msg" class="display-hide" data-name="iYYJLRYF">
    <button class="close" data-close="alert"></button>
    <span id='msg-text'><span>
</div>
<div class="col-md-6 create-form" data-name="qDwPVqxQ">
    <!-- BEGIN FORM-->

            @if($action == 'add')
        <form action="" method="POST" id="spintags-frm" class="kt-form kt-form--label-right" autocomplete="off">
            <input type="hidden" name="_token" value="{{ csrf_token() }}">
            <input type="hidden" id="action" value="add">
            @else
                    <form action="{{ route('spintag.update', $spintag->id) }}" method="POST" id="spintags-frm" autocomplete="off" class="kt-form kt-form--label-right">
                    <input type="hidden" id="action" value="edit">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                    <input type="hidden" id="spintag-id" value="{{$spintag->id}}">
                    <input type="hidden" name="_method" value="PUT">
                    @endif

            <div class="row" data-name="CsVHvaMg">
            <div class="kt-portlet kt-portlet--height-fluid" data-name="htrXTgbB">
                <div class="kt-portlet__head" data-name="oxzDIHtQ">
                    <div class="kt-portlet__head-label" data-name="HtSmybcH">
                        <h3 class="kt-portlet__head-title">{{trans('spintag.form_heading')}}</h3>
                    </div>
                </div>
                <div class="kt-portlet__body" data-name="lEEPdWuL">
                    <div class="form-body" data-name="iJyAYkhn">

                        <div class="form-group row" data-name="BJoYyLHV">
                            <div class="col-md-3" data-name="zPiJOnvC">
                                <label class="col-form-label">
                                @lang('spintag.templates.add.enable_users')
                                    <i class="fa fa-question-circle popovers" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="@lang('spintag.templates.add.enable_users_desc')" data-original-title="@lang('spintag.templates.add.enable_users_desc_only')"></i>
                                </label>
                            </div>
                            <div class="col-md-6" id="pops" data-name="gTclcHpR">

                                <div class="input-icon dis-dang" data-name="DRupCHlr">

                                    <span class="kt-switch kt-switch--outline kt-switch--icon kt-switch--success">
										<label>
                                            @if(!isset($spintag))
											<input checked id="enabled_for_users" type="checkbox" autocomplete="off"  name="enabled_for_users" >
                                            @else
                                                <input {{$spintag->enabled_for_users==1?'checked':''}} id="enabled_for_users" type="checkbox" autocomplete="off"  name="enabled_for_users" >
                                            @endif
											<span></span>
										</label>
									</span>

                                </div>
                            </div>
                        </div>

                        <!-- Name / Placeholder -->
                        <div class="form-group row" data-name="oRssRNWB">
                            <div class="col-md-12" data-name="zPiJOnvC">
                                <label class="col-form-label">{{trans('spintag.form.name')}}
                                    <span class="required">  </span>
                                     {!! popover( 'spintag.form.name_description','common.description' ) !!}
                                </label>
                                <div class="input-icon right" data-name="VwyBNeSC">
                                    <input type="text" name="place_holder" class="form-control" {{isset($spintag->place_holder) ? "readonly" : '' }} value="{{isset($spintag->place_holder) ? $spintag->place_holder : '' }}" />
                                </div>
                            </div>
                        </div>
                        <!-- Name / Placeholder -->

                        <!-- List of Words -->
                        <div class="form-group row" data-name="nodWCubL">
                            <div class="col-md-12" data-name="FzsYCeQb">
                                <label class="col-form-label">{{trans('spintag.form.words')}} <span class="required"> * </span>
                                    {!! popover( 'spintag.form.words_description','common.description' ) !!}
                                </label>
                                <div class="input-icon right" data-name="CnEEMVhY">
                                    <textarea name="word_list" class="form-control" rows="12">{{@$spintag->word_list}}</textarea>
                                </div>
                            </div>
                        </div>
                        <!-- List of Words -->        
                        
                        <div class="form-group row" data-name="oRssRNWB">
                            <div class="col-md-12" data-name="zPiJOnvC">
                                <label class="col-form-label">{{trans('spintag.form.description')}}
                                     {!! popover( 'spintag.form.description_description','common.description' ) !!}
                                </label>
                                <div class="input-icon right" data-name="VwyBNeSC">
                                    <input type="text" name="description" class="form-control" value="{{@$spintag->description}}" />
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="kt-portlet__foot" data-name="OxaAdMjo">
                    <div class="form-actions" data-name="YPOFBFiA">
                        <div class="row" data-name="lHKALCdk">
                            <div class="col-md-12" data-name="jGvUwMJD">
                                <input type="hidden"  name="enabled_for_users_flag" value="1">
                                <!-- save & exit -->
                                <button type="submit" name="save_exit" class="btn btn-success" value="save_exit">{{trans('common.form.button.save')}}</button>
                                <!-- cancel -->
                                <a href="{{ route('spintag.templates') }}"><button type="button" class="btn btn-default">{{trans('common.form.button.cancel')}}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <!-- END FORM-->
</div>
@endsection