@extends(decide_template())

@section('title', $pageTitle)

@section('page_styles')
<link href="/resources/assets/css/spintags-view.css?v={{$local_version}}" rel="stylesheet" type="text/css">
<style>

#spintag_templates tr td, #spintag_templates tr th {
    text-align: center;
    padding: 10px 15px !important;
}
#spintag_templates tr td:nth-child(2), #spintag_templates tr th:nth-child(2) {
    text-align: left;
}
#spintag_templates tr td:nth-child(3), #spintag_templates tr th:nth-child(3) {
    text-align: left;
    width: 120px;
}
#spintag_templates tr td:nth-child(4), #spintag_templates tr th:nth-child(4) {
    max-width: 110px;
    text-align: center;
    padding: 10px !important;
}
#spintag_templates tr td:last-child, #spintag_templates tr th:last-child {
    text-align: center;
    max-width: 70px;
}
</style>
@endsection

@section('page_scripts')
<script src="/themes/default/js/select2.full.min.js" type="text/javascript"></script>
<script src="/themes/default/js/datatables.bundle.js" type="text/javascript"></script>
<script src="/themes/default/js/components-bootstrap-multiselect.min.js" type="text/javascript"></script>
<script src="/themes/default/js/bootstrap-multiselect.js" type="text/javascript"></script>
<script src="/themes/default/js/includes/common.js" type="text/javascript"></script>
<script>
    var objTable;
    var record_type = 'our_records';
    $(document).ready(function() {

        var page_limit=show_per_page('','spintag_pageLength',10);  // Params (table,page,default_limit=10)
        var table=$('#spintag_templates').DataTable({
            "aoColumnDefs": [{"bSortable": false, "aTargets": [0,2,3,5]}],
            "bProcessing": true,
            "bServerSide": true,
            "aaSorting": [[4, "desc"]],
            "sPaginationType": "full_numbers",
            "sAjaxSource": "{{ url('/getSpintagsTemplates') }}",
            "pageLength" : page_limit,
            "aLengthMenu": [[10, 50, 100, 500], [10, 50, 100, 500]]
        });
        objTable = table;
        page_limit=show_per_page(table,'spintag_pageLength');

        $(".use-template").click(function() {
            $(".blockUI").show();
            setTimeout(() => {
                $(".blockUI").hide();
                $("#templates_modal").modal("hide");
                Command: toastr["success"] ("Tag successfully added!");
                setTimeout(() => {
                    location.reload();
                }, 1500);
            }, 1500);
        });
            
        $("a#help-article").css("display", "block");
        $("a#help-article").attr("href", "https://docs.mumara.com/Campaigns/Campaigns/Spintags");

    });
    function changeStatus(id,class_) {
        var enabled_for_users;
        var enabled = $('.'+class_).is(':checked');
        if(enabled)
            enabled_for_users = 1;
        else
            enabled_for_users = 0;
        $.ajax({
            type   : "PUT",
            url    : "{{ route('spintag.update','') }}/"+id,
            data: {'change_status': 1,'enabled_for_users':enabled_for_users},
            success: function(result) {
                $('.blockUI').hide();
                if(result.status == "success") {
                    Command: toastr["success"](result.message);
                    objTable.draw();
                }
                else
                    Command: toastr["error"] (result.message);
            }
        });
    }
    function deleteSpintag(id) {
        if(confirm('{{trans('common.message.alert_delete')}}')) {
            $("#row_"+id).attr("style", "display:none");
            $.ajax({
                url: "{{ url('/') }}"+'/spintag/'+id,
                type: "DELETE",
                data:{'enabled_for_users':1},
                success: function(result) {
                    if(result == 'delete') {
                        $('#msg').css("display", "flex");
                        $('#msg-text').html('{{trans('common.message.delete')}}');
                        $('#msg').removeClass('display-hide').addClass('alert alert-success');
                        objTable.draw();
                    }
                }
            });
        }
    }
    function deleteAll () {
        if(!$('input:checkbox:checked').length){
            alert('{{trans('common.message.alert_no_record')}}');
            return false;
        }
        if(confirm('{{trans('common.message.alert_delete')}}')) {
            var spintags = $('input:checkbox:checked').map(function() {
                return this.value;
            }).get();
            $.ajax({
                type    : "Delete",
                url: "{{ url('/') }}"+'/spintag/'+spintags,
                data    : {ids: spintags},
                success: function(result) {
                    if(result == 'delete') {
                        window.location.href = "{{route('spintag.templates')}}";
                    }
                }
            });

        }
    }
</script>
    @include('includes.view-pages-filter-script')
@endsection

@section(decide_content())
<!-- will be used to show any messages -->
@if (Session::has('msg'))
<div class="alert alert-success" data-name="vImslclh">
    {{ Session::get('msg') }}
</div>
@endif
<div id="msg" class="display-hide" data-name="MMdZaaxz">
    <button class="close" data-close="alert"></button>
    <span id='msg-text' class="alert-text"><span>
</div>
<div class="row" data-name="WcNBieyo">
    <div class="col-md-12" data-name="XmpxcKeQ">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="kt-portlet kt-portlet--height-fluid" data-name="JHBkYrYy">
            <div class="kt-portlet__body" data-name="ryjVLgtd">
                <div class="table-toolbar" data-name="slIdLFad">
                    <div class="form-group row" data-name="rVNLHXmd">
                        <div class="col-md-12" data-name="ZsiERIPI">
                           
                            <div class="btn-group" data-name="xZOwbdmu">
                                <a href="{{ route('spintag.templates_add') }}">
                                <button id="sample_editable_1_new" class="btn btn-label-success">
                                    <i class="la la-plus"></i> {{trans('common.form.button.add_new')}} 
                                </button></a>
                            </div>

                            <div class="btn-group pull-right" data-name="moCsUQYT">
                                <button class="btn btn-label-info dropdown-toggle" data-toggle="dropdown">
                                    {{ trans('common.button.bulk_actions') }}
                                </button>
                                <ul class="dropdown-menu dropdown-menu-right">
                                    <li>
                                        <a href="javascript:;" onclick="deleteAll();" class=""> <i class="fa fa-remove"></i> {{trans('common.form.button.delete')}}  </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="table-scrollable">
                    <table class="table table-striped table-hover table-checkable" id="spintag_templates" role="grid" >
                        <thead>
                            <tr role="row">
                                <th style="width: 25px;">
                                    <label class="kt-checkbox kt-checkbox--single kt-checkbox--all kt-checkbox--solid">
                                        <input type="checkbox" class="checkboxes checkbox-all-index" autocomplete="off">
                                        <span></span>
                                    </label>
                                </th>
                                <th>{{trans('spintag.view.table_heading.tag')}}</th>
                                <th>{{trans('spintag.view.table_heading.description')}}</th>
                                <th>{{trans('spintag.view.table_heading.enable_users')}}</th>
                                <th>{{trans('spintag.view.table_heading.added_on')}}</th>
                                <th>{{trans('common.table_heading.actions')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>

@endsection