@extends(decide_template())

@section('title', trans('languages.view.title'))

@section('page_styles')
<link href="/themes/default/css/sweetalert2.min.css" rel="stylesheet" type="text/css">
<link href="/resources/assets/css/lang.css?v={{$local_version}}" rel="stylesheet" type="text/css">
@endsection

@section('page_scripts')
<script src="/themes/default/js/datatables.bundle.js" type="text/javascript"></script>
<script src="/themes/default/js/sweetalert2.min.js" type="text/javascript"></script>
<script src="/themes/default/js/jquery.form.min.js" type="text/javascript"></script>
<script src="/themes/default/js/jquery.validate.js" type="text/javascript"></script>
<script src="/themes/default/js/additional-methods.js" type="text/javascript"></script>
<script src="/themes/default/js/init.js" type="text/javascript"></script>
<script src="/themes/default/js/form-controls.js" type="text/javascript"></script>
<script src="/themes/default/js/includes/language.js?v={{$local_version}}" type="text/javascript"></script>
<?php 
    $license_attributes = json_decode(getSetting('license_attributes'), true);
    $license_type = '';
    if (! empty($license_attributes['package'])) {
        $license_type = $license_attributes['package'];
    }
    $app_default_locale = $default_locale;
?>

<script type="text/javascript">
    var download = function (data){
        var link = document.createElement('a');
        link.href = data.filePath + data.fileName ;
        //below you can define a new name
        link.download =data.fileName;
        document.body.appendChild(link);
        link.click();
    }
    function exportLang(locale)
    {
        $.ajax({
            url: '{{route('makeZipTranslation')}}',
            type: "POST",
            data: {'locale':locale},
            xhrFields: {
                responseType: 'blob'
            },
            beforeSend: function () {
                $(".blockUI").show();
            },
            complete: function () {
                $(".blockUI").hide();
            },
            success: function (result) {
                var blob = new Blob([result]);
                var link = document.createElement('a');
                link.href = window.URL.createObjectURL(blob);
                link.download = Date.now()+'.zip';
                link.click();

            }
        });

    }

    @if ( isCommercialLicense("Commercial") || isDeveloperLicense("Mumara Developers"))
    $(document).ready(function() {

        $(".duplicate").click(function() {
            var lang = $(this).attr("data-lang");
            $("#s_lang").val(lang);
            $("#modal-duplicate").modal("show");
           
        });

        $(".download-lang").click(function() {
            var lang = $(this).attr("data-lang");
            $(this).hide();
            $(this).next("i.fa-spin").css("display", "inline-block");
            $.ajax({
                url: '{{route('downloadLang')}}',
                type: "POST",
                data: {'lang':lang},
                success: function (result) {
                    console.log(result)
                    var obj = JSON.parse(result);
                    if(obj["status"] == "error") { 
                        $("i.fa-spin").hide();
                        $(this).parent().children(".download-lang").show();
                        $(this).parent().parent().children(".no-installed").show();
                        $(this).parent().parent().children(".installed").hide();
                        Command: toastr["error"] (obj["message"]);
                    } else { 
                        $("i.fa-spin").hide();
                        $(this).parent().children(".fa-check-circle").show();
                        $(this).parent().parent().children(".no-installed").hide();
                        $(this).parent().parent().children(".installed").css("display", "inline-block");
                        Command: toastr["success"] ("{{trans('Language Successfully installed')}}");
                        setTimeout(() => {
                            location.reload();
                            $(".fa-check-circle").hide();
                        }, 2000);
                    }

                   
                 
                 
                    
                    
                }
            });
          
        });

    $(".uninstall").click(function() {
            var lang = $(this).attr("data-lang");
            $("#error-msg2").show();
            $("#error-msg-upload2").html('{!!trans('user_management.packages.modal.alert_message')!!}'.replace(':package',lang));
           
          document.getElementById("get_users_list").innerHTML="";
        document.getElementById("new_id").innerHTML="";
        document.getElementById("new_id").value = "";
        $('#deleteItem').hide();
        
        var return_select="";
        var return_list = "";
        $.get('/language/check/users/' + lang, function (data) {
      // console.log(data);
        if (data == 'not_exists') {
            Swal.fire({
                title: "{{trans('user_management.view.alert_confirmation.delete_title')}}",
                text: "{{trans('languages.view.alert_message.confirm_description')}}",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "{{trans('common.yes')}}"
            }).then((result) => {
                if (result.isConfirmed) {

                
                        $.ajax({
                        url: '{{route('uninstallLang')}}',
                        type: "POST",
                        data: {'lang':lang},
                        beforeSend: function () {
                            $(".blockUI").show();
                        },
                        complete: function () {
                            $(".blockUI").hide();
                        },
                        success: function (result) {
                            location.reload();
                        }
                    });
                }
            });
        }
        else {
            $("#modal-delete").modal("show");
             document.getElementById("old_id").value = lang;
            $.get('/language/get_languages/' + lang, function (response) {
               return_select += "<option value=''>Select Language</option>"; 
               for (var x = 0; x < response[0].length; x++) {
                return_select += "<option value="+ response[0][x]['locale'] +">"+ response[0][x]['locale'] + "</option> " + response[0][x]['locale'] + " </a></li>";
                }
                var selectContainer=document.getElementById("new_id");
                selectContainer.innerHTML=return_select;
            });
           
             $("#modal-delete").modal("show");
              for (var x = 0; x < data[0].length; x++) {
                 return_list += "<li><a href=\"#\"><i class=\"fa fa-angle-double-right\"></i> " + data[0][x]['name'] + " </a></li>";
             }
             var listContainer = document.getElementById("get_users_list");
             listContainer.innerHTML = "<ul class='no-list'>" + return_list + "</ul>";
            }
            });

            // $.ajax({
            //     url: '{{route('uninstallLang')}}',
            //     type: "POST",
            //     data: {'lang':lang},
            //     beforeSend: function () {
            //         $(".blockUI").show();
            //     },
            //     complete: function () {
            //         $(".blockUI").hide();
            //     },
            //     success: function (result) {
            //         location.reload();
            //     }
            // });
          
        });

        $('#new_id').live('change',function (){
            val =  $('#new_id').val();
            if(val=="")
                $('#deleteItem').hide();
            else
                $('#deleteItem').show();
        });

        $('#deleteItem').live('click',function (){
            
            new_id = $('#new_id').val();
            old_id = $('#old_id').val();
         //   alert(old_id);
          //  alert(new_id);
            $('#new_id-error').html('').hide();
            $(".blockUI").show();
            $.ajax({
                url: "{{ url('/') }}"+'/language/user/shifting/'+new_id+'/'+old_id,
                type: "GET",
                success: function(result) {
                    
                        $(".blockUI").hide();
                        $("#modal-delete").modal("hide");
                        Command: toastr["success"] ("{{trans('user_management.view.success_confirmation.success_description')}}");
                        location.reload();
                   
                }
            });
        });
        $('#new_id2').live('change',function (){
            val =  $('#new_id2').val();
            if(val=="")
                $('#deleteItem2').hide();
            else
                $('#deleteItem2').show();
        });
        $('#deleteItem2').live('click',function (){
            
            new_id = $('#new_id2').val();
            old_id = $('#old_id2').val();
         //   alert(old_id);
          //  alert(new_id);
            $('#new_id-error').html('').hide();
            $(".blockUI").show();
            $.ajax({
                url: "{{ url('/') }}"+'/language/user/shifting/delete/'+new_id+'/'+old_id,
                type: "GET",
                success: function(result) {
                    
                        $(".blockUI").hide();
                        $("#modal-delete2").modal("hide");
                        Command: toastr["success"] ("{{trans('user_management.view.success_confirmation.success_description')}}");
                        location.reload();
                   
                }
            });
        });




        $("#btn-import").click(function() {
            $("#error-msg").hide();
            $("#error-msg-upload").text("");
            $("#modal-import").modal("show");
        });
        
        $("#table-lang").DataTable();
        $('[data-toggle="popover"]').popover();
    });
    @else 
    $(document).ready(function() {
        $(".license-locked").on("click", function() {
            $("#not-allowed-popup").modal("show");
        });
        $("#btn-import").click(function() {
            $("#not-allowed-popup").modal("show");
        });
    });
    @endif
    function switchLang(locale) {
        $.ajax({
            url: '{{route('switchTranslation')}}',
            type: "POST",
            data: {'locale':locale},
            dataType: 'json',
            cache: false,
            beforeSend: function () {
                $(".blockUI").show();
            },
            complete: function () {
                $(".blockUI").hide();
            },
            success: function (result) {
                Command: toastr["success"] (result.message);
                setTimeout(() => {
                    location.reload();
                }, 1500);

            }
        });
    }
    
    function deleteLang(locale) {
            var lang = locale;
            $("#error-msg3").show();
            $("#error-msg-upload3").html('{!!trans('user_management.packages.modal.alert_message')!!}'.replace(':package',lang));
           
          document.getElementById("get_users_list2").innerHTML="";
        document.getElementById("new_id2").innerHTML="";
        document.getElementById("new_id2").value = "";
        $('#deleteItem2').hide();
        
        var return_select="";
        var return_list = "";
        $.get('/language/check/users/' + lang, function (data) {
       
        if (data == 'not_exists') {
                            Swal.fire({
                            title: "",
                            text: "{{trans('languages.view.alert_confirm.delete_description')}}",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#d33',
                            cancelButtonColor: '#3085d6',
                            cancelButtonText: "Cancel",
                            confirmButtonText: "Yes Remove!",
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajax({
                                    url: '{{route('deleteTranslation')}}',
                                    type: "POST",
                                    data: {'locale':locale},
                                    dataType: 'json',
                                    cache: false,
                                    beforeSend: function () {
                                        $(".blockUI").show();
                                    },
                                    complete: function () {
                                        $(".blockUI").hide();
                                    },
                                    success: function (result) {
                                        Swal.fire({
                                            text: result.message,
                                            icon: "success",
                                            showConfirmButton: false,
                                            closeClick: false,
                                            timer: 2000
                                        });
                                        setTimeout(() => {
                                            location.reload();
                                        }, 2100);

                                    }
                                });

                            }
                        });
        }
        else {
            $("#modal-delete2").modal("show");
             document.getElementById("old_id2").value = lang;
            $.get('/language/get_languages/' + lang, function (response) {
               return_select += "<option value=''>Select Language</option>"; 
               for (var x = 0; x < response[0].length; x++) {
                return_select += "<option value="+ response[0][x]['locale'] +">"+ response[0][x]['locale'] + "</option> " + response[0][x]['locale'] + " </a></li>";
                }
                var selectContainer=document.getElementById("new_id2");
                selectContainer.innerHTML=return_select;
            });
           
             $("#modal-delete2").modal("show");
              for (var x = 0; x < data[0].length; x++) {
                 return_list += "<li><a href=\"#\"><i class=\"fa fa-angle-double-right\"></i> " + data[0][x]['name'] + " </a></li>";
             }
             var listContainer = document.getElementById("get_users_list2");
             listContainer.innerHTML = "<ul class='no-list'>" + return_list + "</ul>";
            }
            });

           
          
        };
</script>
@endsection

@section(decide_content())

@if($errors->any())
    <!-- For PHP validations errors-->
    <div class="alert alert-danger" data-name="eNToTnJj">
        @foreach($errors->all() as $error)
            <p>{{ $error }}</p>
        @endforeach
    </div>
@endif
<!-- will be used to show any messages -->
@if (Session::has('msg'))
<div class="alert alert-success" data-name="DJlRjxcu">
    {{ Session::get('msg') }}
</div>
@endif
<!-- will be used to show any messages -->
<div id="msg" class="display-hide" data-name="rQbTOcrq">
    <button class="close" data-close="alert"></button>
    <span id='msg-text'><span>
</div>
<div class="col-md-8" data-name="PvKgzkQt">
    <div class="row" data-name="vehsWUet">
        <div class="kt-portlet kt-portlet--height-fluid" data-name="kxmTfGzI">
            <div class="kt-portlet__body" data-name="DHdFBzAq">
                <div class="table-toolbar" data-name="vRJjWcLs">
                    <div class="form-group row" data-name="RCqDLbdE">
                        <div class="col-md-12" data-name="fottQcCk">
                            <div class="btn-group" data-name="uUREPBjU">
                                <button id="btn-import" class="btn btn-label-success">
                                    {{trans('languages.view.button.add_new')}}
                                </button>
                            </div>                           
                        </div>
                    </div>
                </div>
                <div class="form-body" data-name="tuBaDhyU">                        
                    <table class="table table-striped table-hover table-checkable" id="table-lang">
                        <thead>
                            <tr>
                                <th>{{trans('languages.view.table_heading.language')}}</th>
                                <th>{{trans('languages.view.table_heading.details')}}</th>
                                <th>{{trans('languages.view.table_heading.author')}}</th>
                                <th>{{trans('languages.view.table_heading.installed')}}</th>
                                @if ( isCommercialLicense("Commercial") || isDeveloperLicense("Mumara Developers"))
                                <th>{{trans('common.table_heading.actions')}}</th>
                                @endif
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($locales as $locale)
                                <?php 
                                if(file_exists(resource_path('lang/'.$locale->locale).'/manifest.php')) {
                                    include_once resource_path('lang/'.$locale->locale).'/manifest.php';
                                    $locale->name = !empty($lang_name)? $lang_name: 'N/A';
                                    $locale->author = !empty($author)? $author: 'N/A';
                                ?>
                                <tr>
                                    <td class="fn">
                                        <div class="lang-name">{{$locale->name}}</div>
                                        @if($app_default_locale==$locale->locale)
                                            {{$app_default_locale}}
                                        <span class="btn btn-label-info">{{trans('languages.view.table_heading.actions.default')}}</span>
                                        @endif
                                    </td>
                                    <td>
                                        {{$locale->locale}}
                                    </td>
                                    <td>
                                        {{$locale->author}}
                                    </td>
                                    <td>
                                        @if($locale->installed == 1)
                                            <span class="btn btn-label-success installed show">installed</span>
                                        @else
                                            <span class="btn btn-label-grey no-installed">Not Installed</span> 
                                            @if ( isCommercialLicense("Commercial") || isDeveloperLicense("Mumara Developers"))
                                            <div class="pb">
                                                <a href="javascript:;" class="download-lang text-info" data-lang="{{$locale->locale}}">
                                                    <i class="fa fa-download"></i>
                                                </a>
                                                <i class="fa fa-spinner fa-spin"></i>
                                                <i class="fa fa-check-circle text-success"></i>
                                            </div>
                                            @else 
                                            <div class="pb">
                                                <a href="javascript:;" class="text-info license-locked" data-lang="{{$locale->locale}}">
                                                    <i class="fa fa-lock"></i>
                                                </a>
                                            </div>
                                            @endif
                                        @endif
                                    </td>
                                    @if ( isCommercialLicense("Commercial") || isDeveloperLicense("Mumara Developers"))
                                    <td>
                                        <div class="dropdown">
                                            <a class="btn btn-label-success btn-icon btn-sm btn-icon-md" data-toggle="dropdown" aria-expanded="false"><i class="flaticon-more-1"></i></a>
                                            <ul class="dropdown-menu dropdown-menu-right" role="menu" x-placement="bottom-end" style="position: absolute; transform: translate3d(-189px, 31px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                {{-- <li>
                                                    <a href="javascript:;" class="install"> <i class="la la-download"></i>{{trans('languages.view.table_heading.actions.install')}} </a>
                                                </li> --}}
                                                @if($app_default_locale!=$locale->locale)
                                                    <li>
                                                        <a href="javascript:;" class="default" onclick="switchLang('{{$locale->locale}}')"> <i class="la la-check-circle"></i>{{trans('languages.view.table_heading.actions.make_default')}} </a>
                                                    </li>
                                                @endif
                                                @if($locale->locale != "en" and  $locale->author != "Mumara")
                                                <li>
                                                    <a href="/languages/{{$locale->id}}/update" class="default"> <i class="la la-edit"></i>{{trans('languages.view.table_heading.actions.update')}} </a>
                                                </li>
                                                @endif
                                                <li>
                                                    <a href="javascript:;" data-lang="{{$locale->locale}}" class="duplicate"> <i class="la la-copy"></i>{{trans('languages.view.table_heading.actions.duplicate')}} </a>
                                                </li>
                                                <li>
                                                    <a onclick="exportLang('{{$locale->locale}}')" href="javascript:;" class="export"> <i class="la la-download"></i>{{trans('languages.view.table_heading.actions.export')}} </a>
                                                </li>
                                                @if($app_default_locale!=$locale->locale AND $locale->locale != "en" and  $locale->author == "Mumara")
                                                <li>
                                                    <a href="javascript:;" class="uninstall" data-lang="{{$locale->locale}}"> <i class="la la-trash"></i>{{trans('languages.view.table_heading.actions.uninstall')}} </a>
                                                </li>
                                               
                                                @endif
                                                @if($app_default_locale!=$locale->locale AND $locale->locale != "en" and  $locale->author != "Mumara")
                                                <li>
                                                    <a href="javascript:;" class="remove" onclick="deleteLang('{{$locale->locale}}')"> <i class="la la-close"></i>{{trans('languages.view.table_heading.actions.delete')}} </a>
                                                </li>
                                                @endif
                                            </ul>
                                        </div>
                                    </td>
                                    @else 
                                    
                                    @endif
                                </tr>
                                <?php } else { ?>

                                    <tr>
                                        <td class="fn">
                                            <div class="lang-name">{{$locale->name ?? "---"}}</div>
                                            @if($app_default_locale==$locale->locale)
                                            <span class="btn btn-label-info">{{trans('languages.view.table_heading.actions.default')}}</span>
                                            @endif
                                        </td>
                                        <td>
                                            {{$locale->locale}}
                                        </td>
                                        <td>
                                            {{$locale->author ?? "Mumara"}}
                                        </td>
                                        <td>
                                            <span class="btn btn-label-grey no-installed">Not Installed</span> 
                                            @if ( isCommercialLicense("Commercial") || isDeveloperLicense("Mumara Developers"))
                                            <div class="pb">
                                                <a href="javascript:;" class="download-lang text-info" data-lang="{{$locale->locale}}">
                                                    <i class="fa fa-download"></i>
                                                </a>
                                                <i class="fa fa-spinner fa-spin"></i>
                                                <i class="fa fa-check-circle text-success"></i>
                                            </div>
                                            @else 
                                            <div class="pb">
                                                <a href="javascript:;" class="text-info license-locked" >
                                                    <i class="fa fa-lock"></i>
                                                </a>
                                                <i class="fa fa-spinner fa-spin"></i>
                                                <i class="fa fa-check-circle text-success"></i>
                                            </div>
                                            @endif
                                        </td>
                                        @if ( isCommercialLicense("Commercial") || isDeveloperLicense("Mumara Developers"))
                                        <td> </td>
                                        @endif
                                    </tr>
                                <?php } ?>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div data-keyboard="false" data-backdrop="static" class="modal fade" id="modal-import" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">{{trans('languages.view.modal_heading.upload_language')}}</h5>
                <!-- <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                </button> -->
            </div>
            <form id="form-import" action="#" method="POST" autocomplete="off">
                <div class="modal-body">
                    <div class="alert alert-warning" id="error-msg">
                        <span class="alert-text" id="error-msg-upload"><span>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-12">
                            {{trans('languages.view.modal.upload_language_description')}}                    
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-form-label col-md-3">
                            {{trans('languages.view.modal.label.upload_file')}}
                            <span class="required"> * </span>
                        </label>
                        <div class="col-md-8">
                            <input type="file" class="form-control" name="file" id="file" accept="application/zip,application/x-zip,application/x-zip-compressed" />
                        </div>
                    </div>
                    <div class="form-group row ">
                        <label class="col-form-label col-md-3"></label>
                        <div class="col-md-8">
                            <button type="submit" class="btn btn-success" id="upload-docs">{{trans('languages.view.button.upload_language')}}</button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('common.form.button.cancel')}}</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-duplicate" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-keyboard="false" data-backdrop="static">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">{{trans('languages.view.modal_heading.duplicate_language')}} <small id="modelLangName">(Arabic - AR)</small></h5>
            </div>
            <form id="form-duplicate" action="#" method="POST" autocomplete="off">
                <div class="modal-body">
                    <div class="alert alert-warning" id="error-msg">
                        <span class="alert-text" id="error-msg-upload"><span>
                    </div>
                    <div class="form-group row">
                        <label class="col-form-label col-md-4">
                            {{trans('languages.form.model.label.language_code')}}
                            <span class="required"> * </span>
                        </label>
                        <div class="col-md-7">
                            <input type="text" class="form-control" placeholder="i.e fr, ar, zh" name="folder_name" id="folder_name" />
                            <input type="hidden" class="form-control"  name="s_lang" id="s_lang" />
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-form-label col-md-4">
                            {{trans('languages.view.modal.label.name')}}
                            <span class="required"> * </span>
                        </label>
                        <div class="col-md-7">
                            <input type="text" class="form-control" name="name" id="lang_name" />
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-form-label col-md-4">
                            {{trans('languages.view.modal.label.author')}}
                            <span class="required"> * </span>
                        </label>
                        <div class="col-md-7">
                            <input type="text" class="form-control" value="{{Auth::user()->name}}" name="author" id="author_name" />
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-form-label col-md-4">
                            {{trans('languages.view.modal.label.fallback')}}
                            <span class="required"> * </span>
                        </label>
                        <div class="col-md-7">
                            <input type="text" class="form-control" value="en" name="fallback" id="fallback_name" />
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-form-label col-md-4">
                            {{trans('languages.view.modal.label.direction')}}
                            <span class="required"> * </span>
                        </label>
                        <div class="col-md-7">
                            <input type="text" class="form-control" value="ltr" name="direction" id="direction_name" placeholder="ltr, rtl" />
                        </div>
                    </div>
                    <div class="form-group row ">
                        <label class="col-form-label col-md-4"></label>
                        <div class="col-md-8">
                            <button type="submit" class="btn btn-success" id="btn-duplicate">{{trans('languages.view.button.upload_language')}}</button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('common.form.button.cancel')}}</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@if ($license_type != 'Commercial ESP')
<style>table#table-lang tr td .pb {margin-top: -8px !important;}table#table-lang tr th:last-child, table#table-lang tr td:last-child {max-width: 200px;min-width: 150px;width: 12%;}table#table-lang tr th:first-child, table#table-lang tr td:first-child {width: 15%;}.table tbody tr td:last-child a.text-info.license-locked:hover>i {color: #4465d2 !important;}</style>
<div class="modal fade" id="not-allowed-popup" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-body text-center">
        <button type="button" class="btn btn-label-grey pull-right btemplates" data-dismiss="modal">{{ trans('common.form.button.close') }}</button>
        <div class="iconBlk">
          <i class="fab fa-expeditedssl"></i>
          <i class="fa fa-shield-alt kt-hide"></i>
        </div>
        <div class="instal-ssl-desc">
          <h4 class="modal-title">{{trans('templates.templates.modal_heading.commercial_feature')}}</h4>
          <p>{{trans('templates.templates.modal.description.feature_not_supported')}}</p>
        </div>
        <a href="https://billing.mumara.com/clientarea.php" target="_blank">
          <button type="button" class="btn btn-primary btn-sm" id="btn-install">Upgrade License</button>
        </a>
      </div>
    </div>
  </div>
</div>
@endif


<div class="modal fade" id="modal-delete" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"data-keyboard="false" data-backdrop="static" >
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">{{trans('user_management.packages.modal_heading.dependency_check')}}</h5>
            </div>
            <form id="form-import" action="#" method="POST" autocomplete="off">
                <div class="modal-body">
                    <div class="alert alert-danger" id="error-msg2">
                        <span class="alert-text" id="error-msg-upload2">{!!trans('languages.view.error_message.re_assign_issue')!!}<span>
                    </div>
                    <div class="row" data-name="igUKVYRO">
                        <div class="col-md-12" data-name="jFQSGZuo">
                            <div id="domain-data" data-name="oyaHdXQR">
                                <div class="list-block" data-name="bDplkoVS">
                                    <div id="assignedAssets" class="row list-scroll" data-name="BwVlKOtK">
                                        <div class="col-md-12" data-name="ZKtDemZp">
                                            <label class="col-form-label">{{trans('user_management.packages.modal.label.users')}}</label>
                                            <div id="get_users_list"></div>
                                           
                                        </div>
                                    </div>

                                    <div id="unassignedAssets" style="/* display: none; */" class="row" data-name="dhlPjruh">
                                        <div class="col-md-12" data-name="jyMxdqfv">
                                            <label class="col-form-label" id="moveToLabel"></label>
                                            <div class="form-group mb0" data-name="hnTUjGZs">
                                                <small id="new_id-error" class="error invalid-feedback"></small>
                                                <input type="text" id="old_id" name="old_id" hidden >
                                                <select name="new_id" class="form-control m-select2" required data-placeholder="{{trans('user_management.packages.modal.label_placeholder.select_package')}}" id="new_id">
                                                    
                                                 </select>
                                            </div>
                                            <small id="sm">{{trans('languages.view.modal.re_assign_help_text')}} </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer" data-name="lCYRZcBU">
                    <button type="button" class="btn btn-secondary btn-sm pull-left" data-dismiss="modal">{{trans('common.form.button.close')}}</button>
                    <button style="display:none;" type="button" class="btn btn-primary btn-sm pull-right" id="deleteItem">Re-assign and Uninstall</button>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-delete2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"data-keyboard="false" data-backdrop="static" >
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">{{trans('user_management.packages.modal_heading.dependency_check')}}</h5>
            </div>
            <form id="form-import" action="#" method="POST" autocomplete="off">
                <div class="modal-body">
                    <div class="alert alert-danger" id="error-msg3">
                        <span class="alert-text" id="error-msg-upload3">{!!trans('languages.view.error_message.re_assign_issue')!!}<span>
                    </div>
                    <div class="row" data-name="igUKVYRO">
                        <div class="col-md-12" data-name="jFQSGZuo">
                            <div id="domain-data" data-name="oyaHdXQR">
                                <div class="list-block" data-name="bDplkoVS">
                                    <div id="assignedAssets" class="row list-scroll" data-name="BwVlKOtK">
                                        <div class="col-md-12" data-name="ZKtDemZp">
                                            <label class="col-form-label">{{trans('user_management.packages.modal.label.users')}}</label>
                                            <div id="get_users_list2"></div>
                                           
                                        </div>
                                    </div>

                                    <div id="unassignedAssets" style="/* display: none; */" class="row" data-name="dhlPjruh">
                                        <div class="col-md-12" data-name="jyMxdqfv">
                                            <label class="col-form-label" id="moveToLabel"></label>
                                            <div class="form-group mb0" data-name="hnTUjGZs">
                                                <small id="new_id-error" class="error invalid-feedback"></small>
                                                <input type="text" id="old_id2" name="old_id2" hidden >
                                                <select name="new_id2" class="form-control m-select2" required data-placeholder="{{trans('user_management.packages.modal.label_placeholder.select_package')}}" id="new_id2">
                                                    
                                                 </select>
                                            </div>
                                            <small id="sm">{{trans('languages.view.modal.re_assign_help_text')}} </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer" data-name="lCYRZcBU">
                    <button type="button" class="btn btn-secondary btn-sm pull-left" data-dismiss="modal">{{trans('common.form.button.close')}}</button>
                    <button style="display:none;" type="button" class="btn btn-primary btn-sm pull-right" id="deleteItem2">Re-assign and Deleted</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection