<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["page"]["title"] = "PowerMTA Integration";
$lang["page"]["description"] = "Seamlessly integrate your PowerMTA server with Mumara to enhance your email delivery infrastructure. With this integration, Mumara handles all the complex routing, sending, and tracking, allowing you to focus on optimizing your email campaigns while ensuring high deliverability and efficient management.";
$lang["edit"]["page"]["title"] = "Edit PowerMTA Server";
$lang["add_new"]["step1"]["title"] = "Version and Webmonitor";
$lang["add_new"]["step1"]["description"] = "Select the PowerMTA version and input webmonitor details.";
$lang["add_new"]["step1"]["form"]["heading"] = "PowerMTA Web Monitor Settings";
$lang["add_new"]["step1"]["form"]["description"] = "Select the PowerMTA version you’ve installed and enter the web monitor address in the correct format (e.g., 192.168.0.11:8080). Choose either HTTP or HTTPS based on your configuration. If SSL is not installed on the PowerMTA web monitor, select HTTP.";
$lang["add_new"]["step1"]["form"]["protocol"] = "Protocol";
$lang["add_new"]["step1"]["form"]["pmta_access_url"] = "Web Monitor Access URL";
$lang["add_new"]["step1"]["form"]["pmta_access_url_help"] = "PowerMTA Web Monitor Access URL";
$lang["add_new"]["step1"]["form"]["pmta_access_url_note"] = "e.g. 192.168.0.1:8080.  If it's not accessible then make sure your IP has access to it. Otherwise add this line at the top of your PowerMTA config file and reload (without quotes) 'http-access :ip admin', or check the firewall.";
$lang["add_new"]["step1"]["form"]["verify_help"] = "If the connectivity check fails, it means the " . $lang["variables"]["site_title"] . " server cannot access your PowerMTA web monitor. To resolve this, ensure that the " . $lang["variables"]["site_title"] . " server's IP address is added to your PowerMTA configuration.";
$lang["add_new"]["step1"]["form"]["failed_note"] = "Even if connectivity is unsuccessful, you can proceed to the next step since " . $lang["variables"]["site_title"] . " will still apply the necessary changes and overwrite the configurations at the end.";
$lang["add_new"]["step2"]["title"] = "Server Connection";
$lang["add_new"]["step2"]["description"] = "Link your PowerMTA server with Mumara.";
$lang["add_new"]["step2"]["form"]["heading"] = "Server Connection";
$lang["add_new"]["step2"]["form"]["description"] = "Connect to the server where PowerMTA is installed.";
$lang["add_new"]["step2"]["form"]["server_name"] = "Server Name";
$lang["add_new"]["step2"]["form"]["server_name_help"] = "Enter a friendly name to easily identify the server.";
$lang["add_new"]["step2"]["form"]["server_ip"] = "Server IP";
$lang["add_new"]["step2"]["form"]["server_ip_help"] = "Provide the main IP address of the server.";
$lang["add_new"]["step2"]["form"]["ssh_port"] = "SSH Port";
$lang["add_new"]["step2"]["form"]["ssh_port_help"] = "Input the port number for SSH connection.";
$lang["add_new"]["step2"]["form"]["username"] = "Username";
$lang["add_new"]["step2"]["form"]["username_help"] = "Enter the server username (e.g., root).";
$lang["add_new"]["step2"]["form"]["password"] = "Password";
$lang["add_new"]["step2"]["form"]["password_help"] = "Provide the root password of the server.";
$lang["add_new"]["step2"]["form"]["operating_system"] = "Operating System";
$lang["add_new"]["step2"]["form"]["operating_system_help"] = "Select the operating system installed on the server";
$lang["add_new"]["step2"]["form"]["centos6"] = "CentOS 6.x";
$lang["add_new"]["step2"]["form"]["centos7"] = "CentOS 7.x";
$lang["add_new"]["step2"]["form"]["ubuntu"] = "Ubuntu";
$lang["add_new"]["step2"]["form"]["step2_help"] = "Verifying the connection is essential. If the connection fails, " . $lang["variables"]["site_title"] . " won't be able to apply the configuration or create the required folders.";
$lang["add_new"]["step3"]["title"] = "SMTP Settings";
$lang["add_new"]["step3"]["description"] = "Configure SMTP settings for the sending nodes.";
$lang["add_new"]["step3"]["form"]["heading"] = "SMTP Settings";
$lang["add_new"]["step3"]["form"]["description"] = "Configure the SMTP settings that your sending nodes will use to feed PowerMTA.";
$lang["add_new"]["step3"]["form"]["host_help"] = "This hostname will be used as the SMTP host for your sending nodes.";
$lang["add_new"]["step3"]["form"]["host_suggestion"] = "This is a suggested SMTP host, but you can modify it as needed.";
$lang["add_new"]["step3"]["form"]["port_help"] = "Specify the port number for the SMTP connection.";
$lang["add_new"]["step3"]["form"]["encryption_help"] = "Select the encryption if you want the SMTP connection to be encrypted.";
$lang["add_new"]["step4"]["title"] = "PMTA Settings";
$lang["add_new"]["step4"]["description"] = "Adjust PowerMTA settings for optimized performance.";
$lang["add_new"]["step4"]["form"]["heading"] = "PowerMTA Settings";
$lang["add_new"]["step4"]["form"]["description"] = "Fill in the necessary fields to set up PowerMTA. Default optimized values are pre-filled; adjust them only if you are familiar with advanced configurations.";
$lang["add_new"]["step4"]["form"]["physical_path"] = "Config File Path";
$lang["add_new"]["step4"]["form"]["physical_path_help"] = "The location where PowerMTA config file exists.";
$lang["add_new"]["step4"]["form"]["management_port"] = "Management Port";
$lang["add_new"]["step4"]["form"]["management_port_help"] = "The port used for accessing the PowerMTA web monitor.";
$lang["add_new"]["step4"]["form"]["admin_ips"] = "Admin IPs";
$lang["add_new"]["step4"]["form"]["admin_ips_help"] = "IP addresses allowed admin access to the PowerMTA web monitor.";
$lang["add_new"]["step4"]["form"]["log_file"] = "Log File";
$lang["add_new"]["step4"]["form"]["log_file_help"] = "Define the log file name and the directory where it will be saved.";
$lang["add_new"]["step4"]["form"]["log_rotation"] = "Log Rotation";
$lang["add_new"]["step4"]["form"]["log_rotation_help"] = "Specify how many log files to retain before rotating.";
$lang["add_new"]["step4"]["form"]["accounting_files"] = "Accounting Files";
$lang["add_new"]["step4"]["form"]["accounting_files_help"] = "Define the name and location of accounting files.";
$lang["add_new"]["step4"]["form"]["account_files_rotation"] = "Accounting Files Retention";
$lang["add_new"]["step4"]["form"]["account_files_rotation_help"] = "Set the duration after which accounting files will be deleted.";
$lang["add_new"]["step4"]["form"]["diag_files"] = "Diag Files";
$lang["add_new"]["step4"]["form"]["diag_files_help"] = "Set the name and location of diagnostic files.";
$lang["add_new"]["step4"]["form"]["diag_files_rotation"] = "Diag Files Retention";
$lang["add_new"]["step4"]["form"]["diag_files_rotation_help"] = "Set the duration after which diagnostic files will be deleted.";
$lang["add_new"]["step4"]["form"]["spool_path"] = "Spool Path";
$lang["add_new"]["step4"]["form"]["spool_path_help"] = "Define where spool files will be stored, which is where PowerMTA queues messages for delivery.";
$lang["add_new"]["step4"]["form"]["domain_keys_path"] = "Domain-Keys Path";
$lang["add_new"]["step4"]["form"]["domain_keys_path_help"] = "The directory where private domain keys are stored.";
$lang["add_new"]["step4"]["form"]["dkim_selector"] = "DKIM Selector";
$lang["add_new"]["step4"]["form"]["dkim_selector_help"] = "Set the default selector/prefix for domain keys (e.g., selector._domainkey.domain.com).";
$lang["add_new"]["step4"]["form"]["tracking_domain_prefix"] = "Tracking Domain Prefix";
$lang["add_new"]["step4"]["form"]["tracking_domain_prefix_help"] = "Define the subdomain prefix for tracking domains (e.g., click means click.domain.com).";
$lang["add_new"]["step4"]["form"]["vmta_prefix"] = "VMTA Prefix";
$lang["add_new"]["step4"]["form"]["vmta_prefix_help"] = "Set the prefix for the VMTA (Virtual MTA), which will be sequentially incremented.";
$lang["add_new"]["step4"]["form"]["authentications"] = "Authentications";
$lang["add_new"]["step4"]["form"]["dkim_fallback_domain"] = "DKIM Fallback Domain";
$lang["add_new"]["step4"]["form"]["dkim_fallback_domain_help"] = "A fallback domain to be used as a signatory if the sending domain's DKIM fails.";
$lang["add_new"]["step4"]["form"]["domain_key_size_in_bits"] = "Domain Key Size in Bits";
$lang["add_new"]["step4"]["form"]["domain_key_size_in_bits_help"] = "Define the key size for DKIM signatures that will be generated for sending domains.";
$lang["add_new"]["step5"]["title"] = "IPs and Domains";
$lang["add_new"]["step5"]["description"] = "Configure IP addresses and sending domains.";
$lang["add_new"]["step5"]["form"]["heading"] = "Configure IPs and Domains";
$lang["add_new"]["step5"]["form"]["description"] = "Define the IP addresses and sending domains that will be used for email sending. " . $lang["variables"]["site_title"] . " will generate the optimal combination of IP addresses and domains on the next page, allowing you to rearrange them as needed.";
$lang["add_new"]["step5"]["form"]["ip_addresses"] = "IP Addresses";
$lang["add_new"]["step5"]["form"]["ip_addresses_help"] = "The IP addresses added to your server that will be used for sending email.";
$lang["add_new"]["step5"]["form"]["sending_domains"] = "Sending Domains";
$lang["add_new"]["step5"]["form"]["sending_domains_help"] = "The domains responsible for relaying emails.";
$lang["add_new"]["step5"]["form"]["enter_a_subnet"] = "Enter a Subnet";
$lang["add_new"]["step5"]["form"]["enter_a_subnet_help"] = "If you have a full subnet, enter it here for simplified configuration.";
$lang["add_new"]["step6"]["title"] = "IPs to Domain Mapping";
$lang["add_new"]["step6"]["description"] = "Group IP addresses with domains.";
$lang["add_new"]["step6"]["form"]["heading"] = "IPs to Domains Mapping";
$lang["add_new"]["step6"]["form"]["description"] = "Drag the IP address to the corresponding domain panel to assign them to specific groups. By default, " . $lang["variables"]["site_title"] . " automatically balances the IP addresses for optimal configuration. You can choose to create single sending node per IP address or a single sending node for all IPs within the group.";
$lang["add_new"]["step6"]["form"]["one_two_one"] = "Single sending node per IP";
$lang["add_new"]["step6"]["form"]["one_two_all"] = "Single sending node for all IPs";
$lang["add_new"]["step6"]["form"]["group_name_help"] = "The group name under which these sending nodes will be organized.";
$lang["add_new"]["step6"]["form"]["from_name_help"] = "The name that will appear in the \"From\" field of the email (if sender details are pulled from the sending nodes).";
$lang["add_new"]["step6"]["form"]["from_email_help"] = "The email address that will appear in the email headers (if sender details are pulled from the sending nodes).";
$lang["add_new"]["step6"]["form"]["reply_email_help"] = "The email address where replies will be sent (if sender details are pulled from the sending nodes).";
$lang["add_new"]["step6"]["form"]["bounce_email_help"] = "The email address that will receive delivery failure notifications.";
$lang["add_new"]["step6"]["form"]["tracking_domain"] = "Tracking Domain";
$lang["add_new"]["step6"]["form"]["tracking_domain_help"] = "The subdomain used to brand and mask hyperlinks and image URLs in the email body.";
$lang["add_new"]["step7"]["title"] = "Bounce Processing";
$lang["add_new"]["step7"]["description"] = "Select bounce processing method, and configure bounce mailboxes.";
$lang["add_new"]["step7"]["form"]["heading"] = "Bounce Processing";
$lang["add_new"]["step7"]["form"]["description"] = "Process delivery reports from PowerMTA accounting files";
$lang["add_new"]["step7"]["form"]["host_help"] = "The hostname of the mail server where the bounce email address is hosted.";
$lang["add_new"]["step7"]["form"]["port_help"] = "The port number for POP/IMAP connection.";
$lang["add_new"]["step7"]["form"]["username_help"] = "The username for the mailbox.";
$lang["add_new"]["step7"]["form"]["password_help"] = "The mailbox password.";
$lang["add_new"]["step7"]["form"]["encryption_help"] = "Select the encryption method if your mail server requires encrypted connections.";
$lang["add_new"]["step7"]["form"]["method"] = "Method";
$lang["add_new"]["step7"]["form"]["method_help"] = "Choose POP or IMAP as advised by the mailbox provider.";
$lang["add_new"]["step8"]["title"] = "DNS Records";
$lang["add_new"]["step8"]["description"] = "Add DNS records for authentication.";
$lang["add_new"]["step8"]["form"]["heading"] = "DNS Records";
$lang["add_new"]["step8"]["form"]["description"] = "" . $lang["variables"]["site_title"] . " generates Forward DNS, Reverse DNS, CNAME, and Domain Keys to authenticate your sending domains. Expand the toggles to view the DNS entry values for each domain. You can also download the DNS entries for later use.";
$lang["add_new"]["step9"]["title"] = "Review Config File";
$lang["add_new"]["step9"]["description"] = "Have a look at the final configuration file.";
$lang["add_new"]["step9"]["form"]["heading"] = "Review PowerMTA Configuration";
$lang["add_new"]["step9"]["form"]["description"] = "Review the configuration file generated based on your inputs. If necessary, you can tweak the configuration file in this step, but proceed with caution to ensure accuracy.";
$lang["add_new"]["step10"]["title"] = "Start Deployment";
$lang["add_new"]["step10"]["description"] = "Initiate the PowerMTA server setup.";
$lang["add_new"]["step10"]["form"]["heading"] = "Congratulations! PowerMTA setup is complete.";
$lang["add_new"]["step10"]["form"]["description"] = "" . $lang["variables"]["site_title"] . " is now integrating and configuring your PowerMTA server. Track the performance below!";
$lang["add_new"]["step10"]["form"]["connecting_to_pmta"] = "Connecting to PowerMTA web monitor";
$lang["add_new"]["step10"]["form"]["connecting_to_server"] = "Connecting to the server";
$lang["add_new"]["step10"]["form"]["checking_required_folder"] = "Checking for required folders";
$lang["add_new"]["step10"]["form"]["backup_pmta_config"] = "Backing up current PowerMTA configuration";
$lang["add_new"]["step10"]["form"]["configure_pmta"] = "Configuring PowerMTA";
$lang["add_new"]["step10"]["form"]["verify_private_domain_key"] = "Configuring the DKIM files";
$lang["add_new"]["step10"]["form"]["configure_bounce_handler"] = "Setting up bounce handlers";
$lang["add_new"]["step10"]["form"]["configure_sending_domains"] = "Setting up sending domains";
$lang["add_new"]["step10"]["form"]["configure_sending_nodes"] = "Setting up sending nodes";
$lang["add_new"]["step10"]["form"]["starting_pmta"] = "Starting PowerMTA";
$lang["add_new"]["step10"]["form"]["restart_pmta"] = "Restarting PowerMTA web monitor";
$lang["add_new"]["step10"]["form"]["verifying_connections"] = "Verifying connection";
$lang["add_new"]["step10"]["form"]["re_check"] = "Re-check";
$lang["config"]["hvaving_trouble"] = "Having trouble?";
$lang["config"]["view_this_topic"] = "Read this topic";
$lang["config"]["original"] = "Original";
$lang["config"]["table_column"]["server_name"] = "Server Name";
$lang["config"]["table_column"]["smtp_host"] = "SMTP Host";
$lang["config"]["table_column"]["smtp_port"] = "SMTP Port";
$lang["config"]["table_column"]["server_ip"] = "Server IP";
$lang["config"]["table_column"]["pmta_port"] = "Web Monitor Port";
$lang["config"]["buttons"]["reload_pmta"] = "Reload PowerMTA";
$lang["config"]["buttons"]["restart_pmta"] = "Restart PowerMTA";
$lang["config"]["buttons"]["restart_pmta_console"] = "Restart PowerMTA Web Monitor";
$lang["config"]["buttons"]["reboot_server"] = "Reboot Server";
$lang["message"]["verifying"] = "Verifying";
$lang["message"]["propagated"] = "Primary domain needs to be propagated before you can add PowerMTA server.";
$lang["message"]["no_key_found"] = "Key not found";
$lang["message"]["server_not_connected"] = "Error: Error establishing connection";
$lang["message"]["config_updated_successfully"] = "The config file has been updated successfully.";
$lang["message"]["Unable_to_connect"] = "Unable to connect";
$lang["message"]["login_failed"] = "Login failed";
$lang["message"]["login_successful"] = "Login successful";
$lang["message"]["connection_verified"] = "The connection has been verified";
$lang["message"]["connected_with_web_monitor"] = "Connected: Running";
$lang["message"]["not_connected_with_web_monitor"] = "Connected: Stopped";
$lang["message"]["pmta_reloaded"] = "PowerMTA has been reloaded";
$lang["message"]["pmta_restarted"] = "PowerMTA has been restarted";
$lang["message"]["pmta_web_monitor_restarted"] = "PowerMTA web monitor has been restarted";
$lang["message"]["server_restarted"] = "Server has been restarted";
$lang["message"]["mysql_restarted"] = "Mysql has been restarted";
$lang["message"]["invalid_command"] = "Invalid command";
$lang["reverse_dsn_ptr"] = "Reverse DNS (PTR)";
$lang["integrations"] = "Integrations";
$lang["title"] = "PowerMTA";
$lang["set_primary_domain"] = "Set Primary Domain";
$lang["enter_subnet"] = "Enter Subnet";
$lang["congratulations"] = "Congratulations!";
$lang["congratulations_help"] = "Your Power MTA Server has been successfully added!";
$lang["verify_connection"] = "Verify Connection";
$lang["view_configuration"] = "View configuration";
$lang["download_configurations"] = "Download DNS records";
$lang["configuration_for"] = "Configuration for :server_name";
$lang["domains_to_add"] = "Domains to add";
$lang["add_masking_domains"] = "Add Masking Domains";
$lang["add_bounce_emails"] = "Add Bounce Emails";
$lang["add_smtp"] = "Add SMTP/IPs";
$lang["accounts_added"] = "IP/SMTP accounts will be added";
$lang["fdns_entries"] = "FDNS/RDNS entries will be exported as CSV";
$lang["integration_controller"]["edit_configuration_action"] = "Edit credentials";
$lang["integration_controller"]["unauthorized_msg_span"] = "Unauthorized";
$lang["pmta_create_blade"]["download_records_action"] = "Download records";
$lang["pmta_create_blade"]["version_label"] = "Version";
$lang["add_new"]["step2"]["form"]["almalinux9"] = "Almalinux 9";
$lang["add_new"]["step2"]["form"]["almalinux8"] = "Almalinux 8";
$lang["add_new"]["step2"]["form"]["centos8"] = "CentOS 8.x";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
