<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["view"]["title"] = "Add-ons Management";
$lang["view"]["description"] = "Manage your add-ons: install, update, enable, or disable them.";
$lang["view"]["success_message"]["addon_installed"] = "Success: The add-on has been installed successfully.";
$lang["view"]["success_message"]["addon_uninstalled"] = "Success: The add-on has been uninstalled successfully.";
$lang["view"]["error_message"]["not_found"] = "Error: The add-on could not be found.";
$lang["view"]["alert_message"]["status_updated"] = "Success: The add-on status has been updated successfully.";
$lang["view"]["button"]["check_update"] = "Check for updates";
$lang["view"]["widget_heading"]["list_of_addons"] = "Available add-ons";
$lang["view"]["link"]["read_more"] = "Learn more";
$lang["view"]["button"]["version"] = "Version";
$lang["view"]["label_success"]["update_available"] = "Update Available";
$lang["view"]["link"]["launch"] = "Launch";
$lang["view"]["link"]["install"] = "Install";
$lang["view"]["link"]["uninstall"] = "Uninstall";
$lang["view"]["link"]["activated"] = "Enabled";
$lang["view"]["link"]["installed"] = "Installed";
$lang["view"]["modal_heading"]["upload_addon"] = "Upload add-on";
$lang["view"]["modal_heading"]["upload_addon_description"] = "Upload your add-on zip file. " . $lang["variables"]["site_title"] . " will verify the file before installation.";
$lang["view"]["modal"]["label"]["select_file"] = "Select File";
$lang["view"]["modal"]["button"]["upload"] = "Upload";
$lang["view"]["modal"]["label"]["uploading"] = "Uploading...";
$lang["view"]["alert_message"]["check_update_success"] = "Success: Update check in progress.";
$lang["view"]["success_message"]["license_key_saved"] = "License key saved successfully.";
$lang["message"]["install_dir"]["not_found"] = "Error: Install folder missing.";
$lang["view"]["error_message"]["uninstall_dir_not_found"] = "Error: Uninstall folder missing.";
$lang["view"]["error_message"]["not_exists"] = "Error: Add-on :name not found.";
$lang["view"]["error_message"]["file_not_exist"] = "Error: :file is missing.";
$lang["view"]["success_message"]["addon_removed"] = "Add-on removed successfully.";
$lang["view"]["success_message"]["addon_updated"] = "Add-on updated successfully.";
$lang["view"]["success_message"]["addon_uploaded"] = "Add-on uploaded successfully.";
$lang["view"]["error_message"]["license_verfied"] = "License key verified successfully.";
$lang["view"]["error_message"]["license_key_not_found"] = "Error: License key not found.";
$lang["view"]["error_message"]["already_exists"] = "Error: Add-on :name already exists.";
$lang["view"]["error_message"]["invalid_addon"] = "Error: Invalid add-on structure.";
$lang["view"]["error_message"]["zip_extension_not_found"] = "Error: ZIP extension is missing.";
$lang["view"]["error_message"]["upload_file_size"] = "Error: File size exceeds :size.";
$lang["view"]["alert_message"]["upload_max_filesize"] = "Error: File size exceeds the upload limit.";
$lang["view"]["alert_warning"]["no_addon_available"] = "No add-ons are available.";
$lang["view"]["label"]["max"] = "Maximum";
$lang["view"]["alert_message"]["issue_resolved"] = "Issue resolved successfully.";
$lang["view"]["alert_message"]["issue_not_resolved"] = "Error: Issue not resolved, please try again later.";
$lang["view"]["button"]["title_resolve"] = "Mark as Resolved";
$lang["view"]["button"]["retry"] = "Retry";
$lang["view"]["button"]["verify"] = "Verify";
$lang["view"]["link"]["insert_license_key"] = "Enter License Key";
$lang["view"]["link"]["license_key"] = "License Key";
$lang["view"]["modal_heading"]["license_required"] = "License Required";
$lang["view"]["modal_heading"]["license_required_description"] = "A valid license is required to install this add-on.";
$lang["view"]["error_message"]["php_exec_disable_exception"] = "PHP exec is disabled.";
$lang["view"]["error_message"]["downloading_file_exception"] = "Error downloading file.";
$lang["view"]["label"]["version"] = "Version:";
$lang["view"]["label"]["vendor"] = "Vendor:";
$lang["view"]["label"]["support_expire_on_span"] = "Support Expires On:";
$lang["view"]["tooltip"]["activate"] = "Activate Add-on";
$lang["view"]["tooltip"]["deactivate"] = "Deactivate Add-on";
$lang["view"]["icon"]["uninstall"] = "Uninstall Add-on";
$lang["view"]["icon"]["install"] = "Install Add-on";
$lang["view"]["tooltip"]["remove"] = "Remove Add-on";
$lang["view"]["error_message"]["enter_license"] = "Enter License Key";
$lang["index_backup_blade"]["form_errors_command"] = "Please correct the errors in the form below.";
$lang["google2fa"]["alert_message"]["login_required"] = "Two-factor authentication code required for login.";
$lang["google2fa"]["alert_message"]["save_for_future"] = "Keep this safe for future use.";
$lang["google2fa"]["alert_warning"]["cant_access_device"] = "Can't access your 2FA device?";
$lang["google2fa"]["alert_warning"]["login_code"] = "Use a backup code to log in.";
$lang["google2fa"]["alert_warning"]["two_factor_code"] = "Two-Factor Code";
$lang["google2fa"]["input_placeholder"]["authentication_code"] = "Authentication Code";
$lang["google2fa"]["input_placeholder"]["backup_code"] = "Backup Code";
$lang["google2fa"]["alert_message"]["code_valid_once"] = "Backup codes are valid for one use. They will be reset.";
$lang["google2fa"]["label"]["processing"] = "Processing...";
$lang["google2fa"]["alert_message"]["passed_authentication"] = "Authentication successful. Redirecting to the Dashboard.";
$lang["google2fa"]["alert_message"]["navigate_dashboard"] = "Login successful. Redirecting to the Dashboard.";
$lang["google2fa"]["label"]["one_time_backup_code"] = "Your new one-time backup code is:";
$lang["google2fa"]["zapier"]["only_zapier"] = "Only accessible by Zapier.";
$lang["button"]["finished"] = "Completed";
$lang["template"]["alert_message"]["addon_deactivated"] = "The :name addon is currently inactive. Please activate it to proceed.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
