<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('campaigns', 'enabled_for_users'))
        {
            Schema::table('campaigns', function (Blueprint $table) {
                $table->boolean('enabled_for_users')->nullable()->default(null);
            });
        }
        if (!Schema::hasColumn('campaigns', 'description'))
        {
            Schema::table('campaigns', function (Blueprint $table) {
                $table->text('description')->nullable()->default(null);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        if (Schema::hasColumn('campaigns', 'enabled_for_users'))
        {
            Schema::table('campaigns', function (Blueprint $table) {
                $table->dropColumn('enabled_for_users');
            });
        }
        if (Schema::hasColumn('campaigns', 'description'))
        {
            Schema::table('campaigns', function (Blueprint $table) {
                $table->dropColumn('description');
            });
        }
    }
};
