<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\File;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('translations', function (Blueprint $table) {
            // Truncate table before schema modification (use with caution)
            DB::table('translations')->truncate();
    
            // Add 'name' column if it doesn't exist
            if (!Schema::hasColumn('translations', 'name')) {
                $table->string('name')->after('locale');
            }
    
            // Modify 'created_at' column if it exists
          
    
            // Modify 'installed' column if it exists
            if (Schema::hasColumn('translations', 'installed')) {
                $table->integer('installed')->after('name')->change();
            }
        });
    
        // Array of languages to insert
        $languages = [
            ['lang_name' => 'Arabic', 'default_locale' => 'ar'],
            ['lang_name' => 'German', 'default_locale' => 'de'],
            ['lang_name' => 'English - US', 'default_locale' => 'en'],
            ['lang_name' => 'Spanish', 'default_locale' => 'es'],
            ['lang_name' => 'French', 'default_locale' => 'fr'],
            ['lang_name' => 'Hindi', 'default_locale' => 'hi'],
            ['lang_name' => 'Italian', 'default_locale' => 'it'],
            ['lang_name' => 'Japanese', 'default_locale' => 'ja'],
            ['lang_name' => 'Korean', 'default_locale' => 'ko'],
            ['lang_name' => 'Norwegian', 'default_locale' => 'no'],
            ['lang_name' => 'Polish', 'default_locale' => 'pl'],
            ['lang_name' => 'Portuguese', 'default_locale' => 'pt'],
            ['lang_name' => 'Romanian', 'default_locale' => 'ro'],
            ['lang_name' => 'Russian', 'default_locale' => 'ru'],
            ['lang_name' => 'Serbian', 'default_locale' => 'sr'],
            ['lang_name' => 'Swedish', 'default_locale' => 'sv'],
            ['lang_name' => 'Urdu', 'default_locale' => 'ur'],
            ['lang_name' => 'Chinese (Simplified)', 'default_locale' => 'zh-CN'],
        ];
    
        // Insert new language data
        foreach ($languages as $language) {
            $exists = DB::table("translations")
                ->where("locale", $language['default_locale'])
                ->exists();
    
            if (!$exists) {
                $installed = ($language['default_locale'] === 'en') ? 1 : 0;
    
                DB::table("translations")->insert([
                    'locale' => $language['default_locale'],
                    'name' => $language['lang_name'],
                    'installed' => $installed,
                    'created_at' => now(),
                    'updated_at' => now()
                ]);
            }
        }
    
        // Remove Dutch (nl) language if it exists
        $nl_exists = DB::table("translations")->where("locale", "nl")->exists();
        if ($nl_exists) {
            DB::table("translations")->where("locale", "nl")->delete();
        }
    }
    

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
       

     }
};
