<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $segmentPermission = \App\Models\Permission::where('route','segments.index')->first();
        if(!is_null($segmentPermission))
            addChildPermission('Copy Segment Template','1','web','0','0','all','5','segment.clone',$segmentPermission->id,'clone_segment_template');
        \Illuminate\Support\Facades\DB::statement("UPDATE `mainmenu` SET `routes` = 'segments||segment/*||segment/add||segments/view-segment/{id}||segments/export/{id}||segments/subscribers/{id}||segment/edit/{id}||segment/templates||segment/template/add||segment/template/{id}/edit' WHERE `mainmenu`.`id` = 13;");
        \Illuminate\Support\Facades\DB::statement("UPDATE `mainmenu` SET `routes` = 'lists||list/add||list/{list}/edit||list/{list}||list-management/{list}||fields||field/add||field/{field}/edit||segments||segment/add||segments/*||suppression-email||suppression-domain||suppression-ip||segments/view-segment/{id}||segments/export/{id}||segments/subscribers/{id}||segment/edit/{id}||segment/templates||segment/template/add||segment/template/{id}/edit' WHERE `mainmenu`.`id` = 1;");
        $roles = \App\Models\Role::where('id', '!=', 1)->where('type','web')->pluck('id')->toArray();
        $segmentCopyPermission = \App\Models\Permission::where('permission','clone_segment_template')->first();
        if(!is_null($segmentCopyPermission)) {
            foreach ($roles as $role) {
                $permission_role = \App\Models\RolePermission::where('role_id', $role)->first();
                if (!is_null($permission_role)) {
                    \App\Models\RolePermission::firstOrCreate(['role_id' => $role, 'permission_id' => $segmentCopyPermission->id]);
                }
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $segmentCopyPermission = \App\Models\Permission::where('permission','clone_segment_template')->first();
        if(!is_null($segmentCopyPermission)) {
            \App\Models\RolePermission::where('permission_id', $segmentCopyPermission->id)->delete();
            $segmentCopyPermission->delete();
        }
        \Illuminate\Support\Facades\DB::statement("UPDATE `mainmenu` SET `routes` = 'segments||segment/*||segment/add||segments/view-segment/{id}||segments/export/{id}||segments/subscribers/{id}||segment/edit/{id}' WHERE `mainmenu`.`id` = 13;");
        \Illuminate\Support\Facades\DB::statement("UPDATE `mainmenu` SET `routes` = 'lists||list/add||list/{list}/edit||list/{list}||list-management/{list}||fields||field/add||field/{field}/edit||segments||segment/add||segments/*||suppression-email||suppression-domain||suppression-ip||segments/view-segment/{id}||segments/export/{id}||segments/subscribers/{id}||segment/edit/{id}' WHERE `mainmenu`.`id` = 1;");

    }
};
