<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $roles = \App\Models\Role::where('id', '!=', 1)->where('type','web')->pluck('id')->toArray();
        $spinTagCopyPermission = \App\Models\Permission::where('permission','clone_spintag')->first();
        if(!is_null($spinTagCopyPermission)) {
            foreach ($roles as $role) {
                $permission_role = \App\Models\RolePermission::where('role_id', $role)->first();
                if (!is_null($permission_role)) {
                    \App\Models\RolePermission::firstOrCreate(['role_id' => $role, 'permission_id' => $spinTagCopyPermission->id]);
                }
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $spinTagCopyPermission = \App\Models\Permission::where('permission','clone_spintag')->first();
        if(!is_null($spinTagCopyPermission))
        \App\Models\RolePermission::where('permission_id',$spinTagCopyPermission->id)->delete();
    }
};
