<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use App\Models\Permission;
use App\Models\MainMenu;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $defaultPermissions = [
            [
                'route' => 'profileFields.index',
                'title' => 'View Profile Fields',
                'created_at' => '2024-04-16 12:42:38',
            ],
            [
                'route' => 'profileFields.create',
                'title' => 'Add Profile Field',
                'created_at' => '2023-01-04 11:41:12',
            ],
            [
                'route' => 'profileFields.edit',
                'title' => 'Edit Profile Field',
                'created_at' => '2023-01-04 11:41:12',
            ]
        ];

        foreach ($defaultPermissions as $perm) {
            if(!\App\Models\Permission::where('route',$perm['route'])->exists())
            $permission = \App\Models\Permission::firstOrCreate(
                [
                    'route' => $perm['route'],
                    'route_type' => 'web',
                ],
                [
                    'parent_id' => '214',
                    'default_title' => $perm['title'],
                    'title' => $perm['title'],
                    'is_available' => '1',
                    'sequence' => '10000',
                    'route_type' => 'web',
                    'route' => $perm['route'],
                    'skip_in_acl' => '1',
                    'hidden_in_acl' => '1',
                    'access_level' => 'super_admin',
                    'permission' => null,
                    'created_at' => $perm['created_at'],
                    'updated_at' => now(),
                ]
            );
        if(isset($permission))
            if ($perm['route'] === 'profileFields.index') {
                \App\Models\MainMenu::where('link', 'profileFields.index')
                    ->update(['permission' => $permission->id]);
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $routes = ['profileFields.index', 'profileFields.create', 'profileFields.edit'];
        \App\Models\Permission::whereIn('route', $routes)->where('route_type', 'web')->delete();

        \App\Models\MainMenu::where('link', 'profileFields.index')->update(['permission' => null]);
    }
};