<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Storage;
return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        try {
            $getFavicon = DB::table('application_settings')->where('setting_name', 'favicon')->select('setting_value')->first();
            if (!empty($getFavicon) && !empty($getFavicon->setting_value)) {
                $fileName = $getFavicon->setting_value;
                $attachmentDestination = 'branding'; // Assuming the path inside your disk
                $originalFilePath = $attachmentDestination . '/' . $fileName;
                $newFilePath = $attachmentDestination . '/' . 'favicon.ico';
                if (file_exists(storage_path($originalFilePath))) {
                     copy(storage_path($originalFilePath), storage_path($newFilePath));
                } 
            }
           
        } catch (\Exception $e) {
            \Log::error("Error processing favicon: " . $e->getMessage(), ['exception' => $e]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
       
    }
};
