<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $domains_parent = \App\Models\Permission::where('default_title','Sending Domain')->where('route_type','api')->first();
        if(!is_null($domains_parent))
            addChildPermission('Delete Sending Domain','1','api','0','0','all',10000,'deleteSendingDomain',$domains_parent->id);
        $node = addParentPermission('Sending Nodes','1','api','0','0','all',10000,0);
        $node_exists = \App\Models\Permission::where('default_title','Sending Nodes')->where('route_type','api')->first();
            if(!is_null($node_exists)) {
            addChildPermission('Add Sending Node','1','api','0','0','all',10000,'addSendingNode',$node_exists->id);
            addChildPermission('Update Sending Node','1','api','0','0','all',10000,'updateSendingNode',$node_exists->id);
            addChildPermission('Get Sending Nodes','1','api','0','0','all',10000,'getSendingNodes',$node_exists->id);
            addChildPermission('Get Sending Node','1','api','0','0','all',10000,'getSendingNode',$node_exists->id);
            addChildPermission('Delete Sending Nodes','1','api','0','0','all',10000,'deleteSendingNodes',$node_exists->id);
        }
        $form = addParentPermission('Web Forms','1','api','0','0','all',10000,0);
        $form_exists = \App\Models\Permission::where('default_title','Sending Nodes')->where('route_type','api')->first();
            if(!is_null($form_exists)) {
        addChildPermission('Get Web Forms','1','api','0','0','all',10000,'getForms',$form_exists->id);
            addChildPermission('Delete Web Forms','1','api','0','0','all',10000,'deleteForms',$form_exists->id);
        }
        $broadcast = \App\Models\Permission::where('default_title','Broadcast Management')->where('route_type','api')->first();
        if(!is_null($broadcast)) {
            addChildPermission('Get Drips', '1', 'api', '0', '0', 'all', 10000, 'getDrips', $broadcast->id);
            addChildPermission('Delete Drips', '1', 'api', '0', '0', 'all', 10000, 'deleteDrips', $broadcast->id);
        }
        $actions = \App\Models\Permission::where('default_title','Actions')->where('route_type','api')->first();
        if(!is_null($actions)) {
            addChildPermission('Get Triggers','1','api','0','0','all',10000,'getTriggers',$actions->id);
            addChildPermission('Delete Triggers','1','api','0','0','all',10000,'deleteTrigger',$actions->id);
        }
    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
};
