<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $parent = \App\Models\Permission::where('route','exported.files')->first();
        if(!is_null($parent))
        {
            $suppression_export_exists = \App\Models\Permission::where('route','suppression.export.download.csv')->exists();
            if(!$suppression_export_exists){
                addChildPermission('Download Exported Files','1','web','0','0','all',1,'suppression.export.download.csv',$parent->id);
            }
            $parent->update(['default_title'=>'Exported Files','title'=>'Exported Files']);
            $per = \App\Models\Permission::where('route','delete.exported.file')->first();
            if(!is_null($per)){
                $per->update(['parent_id'=>$parent->id,'access_level'=>'all','is_available'=>1,'skip_in_acl'=>0,'hidden_in_acl'=>0]);
            }    
            else
            {
                $delete_export_exists = \App\Models\Permission::where('route','delete.exported.file')->exists();
                if(!$delete_export_exists){
                    addChildPermission('Delete Exported File','1','web','0','0','all',1,'delete.exported.file',$parent->id);
                }   
                $delete_export_all_exists = \App\Models\Permission::where('route','delete.exported.all.file')->exists();
                if(!$delete_export_all_exists){
                    addChildPermission('Delete All Exported Files','1','web','0','0','all',1,'delete.exported.all.file',$parent->id);
                }  
            }  
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
};
